  ## алгоритм Boruta - проверка признаков на релевантность
  ## создаём фрейм с выбранными пятью признаками и зависимой переменной
resultData <- allData

  ## подключаем библиотеки 
library(Boruta)
library(ranger)
  ## устанавливаем зерно ГСЛ для воспроизводимости результатов
set.seed(1)
  ## создаем дата-фрейм с теневые признаки
resultData.extended <- data.frame(resultData, apply(resultData[,-6],2,sample))
  ## даем имена теневым признакам
names(resultData.extended)[7:11] <- paste0('Nonsense',1:5)

  ## создаем объект Boruta
(Boruta.resultData.extended <- Boruta(LnR~.,data=resultData.extended,
                                     mcAdj = TRUE,
                                     doTrace=2, 
                                     ntree = 500, 
                                     maxRuns = 300))
# Boruta performed 183 iterations in 1.892018 secs.
# 2 attributes confirmed important: F3, LnS;
# 8 attributes confirmed unimportant: F1, F2, F4, Nonsense1, Nonsense2 and 3 more;
  ## результат
plot(Boruta.resultData.extended, ylab = 'Важность', xlab = 'Признак')

library(ggplot2)
library(reshape2)
df <- melt(Boruta.resultData.extended$ImpHistory)
shadow95=quantile(Boruta.resultData.extended$ImpHistory[,'shadowMax'],0.975)
shadow75=quantile(Boruta.resultData.extended$ImpHistory[,'shadowMax'],0.75)
windowsFonts('Times New Roman' = windowsFont('Times New Roman'))
ggplot(df, aes(Var2, value)) + geom_boxplot() + xlab('Признак')+ylab('Важность')+
  geom_hline(aes(yintercept=shadow95), colour='green')+
  geom_hline(aes(yintercept=shadow75), colour='yellow')+
  coord_flip()+theme_bw() +
  theme(text=element_text(size=12, family='Times New Roman'))
ggsave('figBorutaEast.png', width = 15, height = 15, units = 'cm')
